(() => {
    // Zaten varsa tekrar ekleme
    if (document.getElementById('imgupla-cropper-container')) return;
  
    const container = document.createElement('div');
    container.id = 'imgupla-cropper-container';
    Object.assign(container.style, {
      position: 'fixed',
      top: '0',
      left: '0',
      width: '100%',
      height: '100%',
      zIndex: '999999',
      cursor: 'crosshair',
      backgroundColor: 'rgba(0, 0, 0, 0.3)'
    });
  
    const selectionBox = document.createElement('div');
    Object.assign(selectionBox.style, {
      border: '2px dashed #fff',
      backgroundColor: 'rgba(255, 255, 255, 0.2)',
      position: 'absolute',
      display: 'none',
      pointerEvents: 'none' // Tıklamaları engellemesin
    });
    container.appendChild(selectionBox);
    document.body.appendChild(container);
  
    let startX, startY;
    let isSelecting = false;
  
    const onMouseDown = (e) => {
      isSelecting = true;
      startX = e.clientX;
      startY = e.clientY;
      selectionBox.style.left = startX + 'px';
      selectionBox.style.top = startY + 'px';
      selectionBox.style.width = '0px';
      selectionBox.style.height = '0px';
      selectionBox.style.display = 'block';
      e.preventDefault();
      e.stopPropagation();
    };
  
    const onMouseMove = (e) => {
      if (!isSelecting) return;
      
      const currentX = e.clientX;
      const currentY = e.clientY;
  
      const width = Math.abs(currentX - startX);
      const height = Math.abs(currentY - startY);
      const left = Math.min(currentX, startX);
      const top = Math.min(currentY, startY);
  
      selectionBox.style.width = width + 'px';
      selectionBox.style.height = height + 'px';
      selectionBox.style.left = left + 'px';
      selectionBox.style.top = top + 'px';
      e.preventDefault();
      e.stopPropagation();
    };
  
    const onMouseUp = (e) => {
      if (!isSelecting) return;
      isSelecting = false;
  
      // Seçim bitti, koordinatları al
      const rect = selectionBox.getBoundingClientRect();
      const area = {
        x: rect.x,
        y: rect.y,
        width: rect.width,
        height: rect.height,
        devicePixelRatio: window.devicePixelRatio
      };
  
      // Temizlik
      document.body.removeChild(container);
      
      // Eğer çok küçük bir alan seçildiyse (yanlışlıkla tıklama gibi) iptal et
      if (area.width < 5 || area.height < 5) {
        alert('Seçilen alan çok küçük!');
        return;
      }
  
      // Arka plana gönder
      chrome.runtime.sendMessage({
        action: 'area_selected',
        area: area
      });
    };
  
    // Event listener'ları ekle
    container.addEventListener('mousedown', onMouseDown);
    container.addEventListener('mousemove', onMouseMove);
    container.addEventListener('mouseup', onMouseUp);
  
    // ESC ile iptal
    const onKeyDown = (e) => {
      if (e.key === 'Escape') {
        document.body.removeChild(container);
        document.removeEventListener('keydown', onKeyDown);
      }
    };
    document.addEventListener('keydown', onKeyDown);
  
  })();
